﻿var startSimulation = {
    context: $(".v-startSimulation"),
    initialize: function () {
        a4.parent().simulations.hideBusyBox();

        $(".h-agents-autocomplete", startSimulation.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetSimulationAgentsForAutoComplete", "Simulation"),
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#AgentId")
        });

        a4.initializeInputs(startSimulation.context);
    },
    bindEvents: function () {
        startSimulation.context.on("click", ".h-startAndClose", function () {
            modalDialog.showConfirmDialog(confirmStartSimulationResources, function () {
                $("#StartSimulationNow", startSimulation.context).val("True");

                var form = $(startSimulation.context).closest("form");
                a4.appendAntiForgeryToken(form);
                form.trigger("submit");
                
            }, 180, 400, false);
        });
    }
};

$(document).ready(function () {
    if (startSimulation.context.length > 0) {
        startSimulation.initialize();
        startSimulation.bindEvents();
    }
});